/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp2;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import cz.insophy.inplan.mrp2.Demand;
import cz.insophy.inplan.mrp2.PropertyTransferer;
import cz.insophy.inplan.mrp2.SortKeyExtractor;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import javax.annotation.Nonnull;

public class GorDemand
implements Demand {
    private final GeneralizedOrderRequest gor;
    private final Material material;
    private final double qty;

    public GorDemand(@Nonnull GeneralizedOrderRequest gor, @Nonnull Material material, double qty) {
        Preconditions.checkArgument(qty > 0.0);
        this.gor = Preconditions.checkNotNull(gor);
        this.material = Preconditions.checkNotNull(material);
        this.qty = qty;
    }

    @Override
    @Nonnull
    public <T> T extractProperties(@Nonnull PropertyTransferer<T> transferer) {
        return transferer.getProperties(this.gor);
    }

    @Override
    @Nonnull
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public double getQty() {
        return this.qty;
    }

    public GeneralizedOrderRequest getGor() {
        return this.gor;
    }

    @Override
    @Nonnull
    public <T extends Comparable<T>> T getSortKey(@Nonnull SortKeyExtractor<T> sortKeyExtractor) {
        return sortKeyExtractor.extract(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("material", this.material).add("qty", this.qty).add("gor", this.gor).toString();
    }
}

